/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 20.2)
 *
 *  Najwaniejszy kod z pytania 20.2 jest w funkcji readline(), reszta 
 *  tego pliku suy do testowania go.
 *
 *  Copyright Steve Summit, 1995
 *  Ten kod moe by dowolnie uywany lub modyfikowany, bd wdziczny 
 *  za podanie rda. Nie daj jednak adnej gwarancji jego dziaania, 
 *  ani nie przyjmuj adnej odpowiedzialnoci za skutki jego 
 *  wykorzystania.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __STDC__
int readlines(FILE *, char ***);
void printlines(char **, int);
void freelines(char **, int);
extern char *agetline(FILE *);
#endif

void printlines();
void freelines();

extern char *agetline();

char *a[4] = {"to", "jest", "tylko", "test"};
char **p = a;

main()
{
printlines(p, 4);

{

char **p = malloc(4 * sizeof(char *));
if(p != NULL) {
	p[0] = malloc(3);
	p[1] = malloc(5);
	p[2] = malloc(6);
	p[3] = malloc(5);

	if(p[0] && p[1] && p[2] && p[3]) {
		strcpy(p[0], "to");
		strcpy(p[1], "jest");
		strcpy(p[2], "tylko");
		strcpy(p[3], "test");
	}
}

printlines(p, 4);
}

while(1)
	{
	char **lines;
	int nlines;
	nlines = readlines(stdin, &lines);
	if(nlines == 0)
		break;
	printlines(lines, nlines);
	freelines(lines, nlines);
	clearerr(stdin);
	}

return 0;
}

readlines(ifp, linesp)
FILE *ifp;
char ***linesp;
{

/* przyjmujemy, e ifp to otwarty ju plik wejciowy */

char **lines = NULL;
size_t nalloc = 0;
size_t nlines = 0;
char *p;

while((p = agetline(ifp)) != NULL) {
	if(nlines >= nalloc) {
		nalloc += 50;
#ifdef SAFEREALLOC
		lines = realloc(lines, nalloc * sizeof(char *));
#else
		if(lines == NULL)		/* jeeli realloc niezgodny z ANSI */
			lines = malloc(nalloc * sizeof(char *));
		else	lines = realloc(lines, nalloc * sizeof(char *));
#endif
		if(lines == NULL) {
			fprintf(stderr, "brak pamici");
			exit(1);
		}
	}

	lines[nlines++] = p;
}

*linesp = lines;

return nlines;
}

void
printlines(lines, nlines)
char **lines;
int nlines;
{
	int i;
	for(i = 0; i < nlines; i++)
		printf("%d \"%s\" (%d)\n", i, lines[i], (int)strlen(lines[i]));
}

void
freelines(lines, nlines)
char **lines;
int nlines;
{
	int i;
	for(i = 0; i < nlines; i++)
		free(lines[i]);
	free(lines);
}
